function res = Freqsort(data, ~,split,nfeat)
%sorts by frequency, each row contains a reading, each column a feature.
%returns a size:  (size(data,1) * "number of groups") array of occurences values,
%highest means most frequent.

if ~isempty(split)
    res=[];
    ssize=floor(nfeat/(length(split)+1));
    for i=1:length(split)+1
        if i==1
            [~,tmp]=sort(sum(data(:,1:split(i))),2,'descend');
            res=[res,tmp(1:ssize)];
        elseif i==(length(split)+1)
            [~,tmp]=sort(sum(data(:,split(i-1)+1:size(data,2))),2,'descend');
            res=[res,tmp(1:ssize)+split(i-1)];
        else
            [~,tmp]=sort(sum(data(:,split(i-1)+1:split(i))),2,'descend');
            res=[res,tmp(1:ssize)+split(i-1)];
        end
    end
else
    [~,tmp]=sort(sum(data),2,'descend');
    res=tmp(1:nfeat);
end
end